<?php

function l23b_get_related_post($attributes) {

	$selected_style = ! empty( $attributes["className"] ) ? $attributes["className"] : 'is-style-default';

	$classname = "wp-block-lab23-blocks-related-post" . ' ' . $selected_style;

	$num = ( ! empty( $attributes['num'] ) && is_numeric( $attributes['num' ]) )
		? $attributes['num']
		: 5;

	if ( is_string($num) ) $num = intval( $num );

	global $post;

	if ( empty( $post ) ) return '';
	$current_post_id = $post->ID;
	$categories = get_the_category( $current_post_id );

	$category_id = array();
	foreach ( $categories as $category ) {
		array_push( $category_id, $category->cat_ID );
	}

	$args = array(
		'post__not_in'    => array( $current_post_id ),
		'posts_per_page'  => $num,
		'category__in'    => $category_id,
		'orderby'         => 'rand',
	);

	$wp_query = new WP_Query($args);

	ob_start();
?>
	<div class="<?php echo $classname; ?>">
		<?php if ( $wp_query->have_posts() ) : ?>
			<?php if ( isset( $attributes['title'] ) && $attributes['title'] ) : ?>
				<h2 class="l23b-related-post-title p-widget__ttl">
					<?php echo $attributes['title']; ?>
				</h2>
			<?php endif; ?>
			<div class="l23b-related-post">
				<?php while ( $wp_query->have_posts() ) : $wp_query->the_post(); ?>
					<?php
					$post_id = get_the_ID();
					$title_length = $selected_style === 'is-style-default' ? 50 : 80;
					$title = get_the_title();
					$title = l23b_mb_substr_text( $title, $title_length );
					$thumb_data = $selected_style === 'is-style-default' ? l23b_get_thumbnail_info( $post_id, "medium" ) : null;
					$datetime = get_the_date( 'Y-m-d', $post_id );
					$time = get_the_date( 'Y.m.d', $post_id );
					?>
					<a href="<?php echo get_the_permalink(); ?>" class="l23b-related-post__item">
						<article class="l23b-related-post-card">
							<?php if ( $thumb_data && isset( $thumb_data[0] ) ): ?>
								<figure class="l23b-related-post-card__thumb">
									<img src="<?php echo $thumb_data[0]; ?>" width="<?php echo $thumb_data[1]; ?>" height="<?php echo $thumb_data[2]; ?>" alt="<?php echo $title; ?>" loading="lazy" />
								</figure>
							<?php endif; ?>
							<div class="l23b-related-post-card__content">
								<h2 class="l23b-related-post-card__title">
									<?php echo $title; ?>
								</h2>
								<p class="l23b-related-post-card__date">
									<time datetime="<?php echo $datetime; ?>"><?php echo $time; ?></time>
								</p>
							</div>
						</article>
					</a>
				<?php endwhile; ?>
			</div>
		<?php else : ?>
			<p class="l23b-no-entry">関連記事はありません。</p>
		<?php endif; ?>
	</div>
<?php
	$content = ob_get_clean();

	wp_reset_postdata();

	return $content;
}

function l23b_register_block_original_related() {
	register_block_type( 'lab23-blocks/related-post', array(
		'editor_script'	=> 'lab23-blocks-editor-script',
		'editor_style'	=> 'lab23-blocks-editor-style',
		'script'		=> 'lab23-blocks-script',
		'style'			=> 'lab23-blocks-style',
		'attributes' 	=> array(
			'num'   => array(
				'type' => 'string',
			),
			'title' => array(
				'type'      => 'string',
				'default'   => __( '関連記事', 'lab23-blocks' ),
			),
		),
		'render_callback' => 'l23b_get_related_post',
	));
}
add_action( 'init', 'l23b_register_block_original_related' );