<?php

function l23b_get_latest_post($attributes)
{

    $selected_style = ! empty( $attributes["className"] ) ? $attributes["className"] : 'is-style-default';

    $classname = "wp-block-lab23-blocks-latest-post" . ' ' . $selected_style;

	$has_thumb = true;

	if ( isset( $attributes['hasThumb'] ) ) {
		$has_thumb = $attributes['hasThumb'];
	} else {
		$has_thumb = true;
	}

    $num = ( ! empty( $attributes['num'] ) && is_numeric( $attributes['num' ]) )
        ? $attributes['num']
        : 5;

    if ( is_string( $num ) ) $num = intval( $num );

    $sticky = get_option('sticky_posts'); //先頭固定の記事

    if ( !empty($sticky) ) $num -= count( $sticky );

    if ( $num <= 0) $num = 1;

    $args = array(
        'posts_per_page'  => $num,
    );

    $wp_query = new WP_Query( $args );

    ob_start();
?>
    <div class="<?php echo $classname; ?>">
        <?php if ( $wp_query->have_posts() ) : ?>
            <div class="l23b-latest-post <?php if ( ! $has_thumb ) echo 'l23b-latest-post--no-image'; ?>">
                <?php while ( $wp_query->have_posts() ) : $wp_query->the_post(); ?>
                    <?php
                    $post_id = get_the_ID();
                    $title = get_the_title();
                    $title = l23b_mb_substr_text( $title, 100 );

					$thumb_data = false;

					if ( $has_thumb ) {
						$thumb_data = l23b_get_thumbnail_info( $post_id, "medium" );
					}
                    
                    $datetime = get_the_date( 'Y-m-d', $post_id );
                    $time = get_the_date( 'Y.m.d', $post_id );
					$has_thumb = $thumb_data && isset( $thumb_data[0] ) && $thumb_data[0];
                    ?>
                    <a href="<?php echo get_the_permalink(); ?>" class="l23b-latest-post__item">
                        <article class="l23b-latest-post-card">
							<figure class="l23b-latest-post-card__thumb">
								<?php if ( $has_thumb ): ?>
                                    <img src="<?php echo $thumb_data[0]; ?>" width="<?php echo $thumb_data[1]; ?>" height="<?php echo $thumb_data[2]; ?>" alt="<?php echo $title; ?>" loading="lazy" />
								<?php endif; ?>
							</figure>
                            <div class="l23b-latest-post-card__content">
                                <h2 class="l23b-latest-post-card__title">
                                    <?php echo $title; ?>
                                </h2>
                                <p class="l23b-latest-post-card__date">
                                    <time datetime="<?php echo $datetime; ?>"><?php echo $time; ?></time>
                                </p>
                            </div>
                        </article>
                    </a>
                <?php endwhile; ?>
            </div>
        <?php else : ?>
            <p class="l23b-no-entry">関連記事はありません。</p>
        <?php endif; ?>
    </div>
<?php
    $content = ob_get_clean();

    wp_reset_postdata();

    return $content;
}

function l23b_register_block_latest_post() {
	register_block_type('lab23-blocks/latest-post', array(
		'editor_script'	=> 'l23b-blocks-editor-script',
		'editor_style'	=> 'l23b-blocks-editor-style',
		'script'		=> 'l23b-blocks-script',
		'style'			=> 'l23b-blocks-style',
		'attributes' 	=> array(
			'title' => array(
				'type' => 'string',
                'default' => __('新着記事', 'lab23-blocks'),
			),
			'num' => array(
				'type' => 'string',
			),
			'hasThumb' => array(
				'type' => 'boolean',
			)
		),
		'render_callback'	=> 'l23b_get_latest_post',
	));
}
add_action('init', 'l23b_register_block_latest_post');