<?php

function l23b_get_latest_post_front($attributes) {
    
    $selected_style = ! empty( $attributes["className"] ) ? $attributes["className"] : 'is-style-default';

    $classname = "wp-block-lab23-blocks-latest-post-front" . ' ' . $selected_style;

    /**
     * 投稿数
     */
    $num = ( ! empty( $attributes['num'] ) && is_numeric( $attributes['num' ]) )
        ? $attributes['num']
        : 5;

    if ( is_string( $num ) ) $num = intval( $num );

    $sticky = get_option('sticky_posts'); //先頭固定の記事

    if ( !empty($sticky) ) $num -= count( $sticky );

    if ( $num <= 0) $num = 1;

    /**
     * クラス名
     */
    $list_class = 'l23b-latest-post-front';

    if ( isset( $attributes['mColumn'] ) && is_numeric( $attributes['mColumn'] ) ) {
        $list_class .= ' l23b-latest-post-front--m-column-' . $attributes['mColumn'];
    }

    if ( isset( $attributes['tColumn'] ) && is_numeric( $attributes['tColumn'] ) ) {
        $list_class .= ' l23b-latest-post-front--t-column-' . $attributes['tColumn'];
    }

    if ( isset( $attributes['pColumn'] ) && is_numeric( $attributes['pColumn'] ) ) {
        $list_class .= ' l23b-latest-post-front--p-column-' . $attributes['pColumn'];
    }
        
    /**
     * style
     */
    $style = '';

    if ( isset( $attributes['pMt'] ) && is_string( $attributes['pMt'] ) ) {
        $style .= '--l23b-latest-post-front-p-mt:' . $attributes['pMt'] . ';';
    }

    if ( isset( $attributes['pMb'] ) && is_string( $attributes['pMb'] ) ) {
        $style .= '--l23b-latest-post-front-p-mb:' . $attributes['pMb'] . ';';
    }

    if ( isset( $attributes['tMt'] ) && is_string( $attributes['tMt'] ) ) {
        $style .= '--l23b-latest-post-front-t-mt:' . $attributes['tMt'] . ';';
    }

    if ( isset( $attributes['tMb'] ) && is_string( $attributes['tMb'] ) ) {
        $style .= '--l23b-latest-post-front-t-mb:' . $attributes['tMb'] . ';';
    }

    if ( isset( $attributes['mMt'] ) && is_string( $attributes['mMt'] ) ) {
        $style .= '--l23b-latest-post-front-m-mt:' . $attributes['mMt'] . ';';
    }

    if ( isset( $attributes['mMb'] ) && is_string( $attributes['mMb'] ) ) {
        $style .= '--l23b-latest-post-front-m-mb:' . $attributes['mMb'] . ';';
    }

    $args = array(
        'posts_per_page'  => $num,
    );

    $wp_query = new WP_Query( $args );

    ob_start();
?>
    <div class="<?php echo $classname; ?>">
        <?php if ( $wp_query->have_posts() ) : ?>
            <div class="<?php echo $list_class ?>" style="<?php echo $style; ?>">
                <?php while ( $wp_query->have_posts() ) : $wp_query->the_post(); ?>
                    <?php
                    $post_id = get_the_ID();
                    $title = get_the_title();
                    $title = l23b_mb_substr_text( $title, 100 );

					$thumb_data = l23b_get_thumbnail_info( $post_id, "large" );
                    
                    $datetime = get_the_date( 'Y-m-d', $post_id );
                    $time = get_the_date( 'Y.m.d', $post_id );

                    $has_thumb = $thumb_data && isset( $thumb_data[0] ) && $thumb_data[0];

                    ?>
                    <div class="l23b-latest-post-front-item">
                        <a href="<?php echo get_the_permalink(); ?>" class="l23b-latest-post-front-item__inner">
                            <figure class="l23b-latest-post-front-item__thumb">
                                <?php if ( $has_thumb ): ?>
                                    <img src="<?php echo $thumb_data[0]; ?>" width="<?php echo $thumb_data[1]; ?>" height="<?php echo $thumb_data[2]; ?>" alt="<?php echo $title; ?>" loading="lazy" />
                                <?php endif; ?>
                            </figure>
                            <div class="l23b-latest-post-front-item__content">
                                <p class="l23b-latest-post-front-item__ttl">
                                    <?php echo $title; ?>
                                </p>
                                <p class="l23b-latest-post-front-item__date">
                                    <time datetime="<?php echo $datetime; ?>"><?php echo $time; ?></time>
                                </p>
                            </div>
                        </a>
                    </div>
                <?php endwhile; ?>
            </div>
        <?php else : ?>
            <p class="l23b-no-entry">関連記事はありません。</p>
        <?php endif; ?>
    </div>
<?php
    $content = ob_get_clean();

    wp_reset_postdata();

    return $content;
}

function l23b_register_block_latest_post_front() {
	register_block_type('lab23-blocks/latest-post-front', array(
		'editor_script'	=> 'l23b-blocks-editor-script',
		'editor_style'	=> 'l23b-blocks-editor-style',
		'script'		=> 'l23b-blocks-script',
		'style'			=> 'l23b-blocks-style',
		'attributes' 	=> array(
			'num' => array(
				'type' => 'string',
			),
            'mColumn' => array(
				'type'		=> 'number',
				'default'	=> 1
			),
			'tColumn' => array(
				'type'		=> 'number',
				'default'	=> 2
			),
			'pColumn' => array(
				'type'		=> 'number',
				'default'	=> 2
			),
            'pMt' => array(
				'type' => 'string',
			),
            'pMb' => array(
				'type' => 'string',
			),
            'tMt' => array(
				'type' => 'string',
			),
            'tMb' => array(
				'type' => 'string',
			),
            'mMt' => array(
				'type' => 'string',
			),
            'mMb' => array(
				'type' => 'string',
			),
		),
		'render_callback'	=> 'l23b_get_latest_post_front',
	));
}
add_action('init', 'l23b_register_block_latest_post_front');