<?php

/**
 * 内部リンク用ブログカード
 * @since 1.0.0
 * @return string
 */
function l23b_get_post_link_callback($attributes) {

	if (empty($attributes['postId'])) return '';

	$post_id   = $attributes['postId'];
	$post_data = get_post($post_id);

	if (empty($post_data)) return '<p class="l23b-card-link__notfound">記事が見つかりませんでした。</p>';

	$selected_style = !empty($attributes["className"]) ? $attributes["className"] : 'is-style-default';
	$class_name = 'l23b-card-link ' . $selected_style;
	$title     = get_the_title($post_id);
	$title     = l23b_mb_substr_text($title, 50);
	$url       = get_permalink($post_id);
	$excerpt   = l23b_get_excerpt($post_id, 140, false);
	$thumb_size = $selected_style === 'is-style-default' ? 'thumbnail' : 'large';
	$thumb_src = l23b_get_thumbnail_url($post_id, 'medium');

	$max_width = isset( $attributes["maxWidth"] ) && ! empty( $attributes["maxWidth"] )
		? $attributes["maxWidth"] : 'none';

	ob_start();
	?>
	<a class="<?php echo $class_name; ?>" href="<?php echo $url; ?>" style="max-width: <?php echo $max_width; ?>;">
		<figure class="l23b-card-link__thumb">
			<img src="<?php echo $thumb_src; ?>" alt="<?php echo $title; ?>" loading="lazy" />
		</figure>
		<div class="l23b-card-link__body">
			<p class="l23b-card-link__ttl"><?php echo $title; ?></p>
			<p class="l23b-card-link__excerpt"><?php echo $excerpt; ?></p>
		</div>
	</a>
	<?php

	$content = ob_get_clean();

	return $content;
}

function l23b_register_block_original_card_link() {
	register_block_type('lab23-blocks/card-link', array(
		'editor_script'	=> 'lab23-blocks-editor-script',
		'editor_style'	=> 'lab23-blocks-editor-style',
		'script'		=> 'lab23-blocks-script',
		'style'			=> 'lab23-blocks-style',
		'attributes' 	=> array(
			'postId' => array(
				'type' => 'string',
			),
			'maxWidth' => array(
				'type' => 'string',
			)
		),
		'render_callback'	=> 'l23b_get_post_link_callback',
	));
}
add_action('init', 'l23b_register_block_original_card_link');