<?php

function l23b_get_entry_slider( $attributes ) {

	if ( ! isset( $attributes['postId'] ) || empty( $attributes['postId'] ) ) return '';

	$post_id = $attributes['postId'];

	if ( get_post_status( $post_id ) !== 'publish' ) return '';

	$parent_style = 'is-style-default';

	if ( isset( $attributes['parentStyle'] ) && ! empty( $attributes['parentStyle'] ) ) {
		$parent_style = $attributes['parentStyle'];
	}

    /**
     * 日付
     */
	$date_type = 'post-update';

    if ( isset( $attributes['dateType'] ) && ! empty( $attributes['dateType'] ) ) {
        $date_type = $attributes['dateType'];
    }

	$title = get_the_title( $post_id );
	$title = l23b_mb_substr_text( $title, 50 );
	$title = esc_attr( $title );

	$thumb_data = l23b_get_thumbnail_info( $post_id, "large" );

	$has_thumb = $thumb_data && isset( $thumb_data[0] ) && $thumb_data[0];

	$has_text = true;

	if ( $parent_style === 'is-style-only-image' || $parent_style === 'is-style-only-image-rounded' ) {
		$has_text = false;
	}

    ob_start();
?>
    <div class="l23b-entry-slider-item swiper-slide">
		<a href="<?php echo get_the_permalink(); ?>" class="l23b-entry-slider-item__inner">
			<figure class="l23b-entry-slider-item__thumb">
				<?php if ( $has_thumb ): ?>
					<img src="<?php echo $thumb_data[0]; ?>" width="<?php echo $thumb_data[1]; ?>" height="<?php echo $thumb_data[2]; ?>" alt="<?php echo $title; ?>" loading="lazy" />
				<?php endif; ?>
			</figure>
			<?php if ( $has_text ) : ?>
				<div class="l23b-entry-slider-item__content">
					<p class="l23b-entry-slider-item__ttl">
						<?php echo $title; ?>
					</p>
					<?php l23b_get_post_date_tag( $post_id, $date_type ); ?>
				</div>
			<?php endif; ?>
		</a>
	</div>
<?php
    $content = ob_get_clean();

    return $content;
}

function l23b_register_block_entry_slider() {
	register_block_type('lab23-blocks/entry-slider', array(
		'editor_script' => 'editor-script-lab23-blocks',
		'editor_style' => 'editor-style-lab23-blocks',
		'script' => 'script-lab23-blocks',
		'style' => 'style-lab23-blocks',
		'attributes' 	=> array(
			'postId' => array(
				'type' => 'string',
				'default' => '',
			),
            'dateType' => array(
				'type' => 'string',
                'default' => 'post-update'
            ),
			'parentStyle' => array(
				'type' => 'string',
				'default' => 'is-style-default',
			),
		),
		'render_callback'	=> 'l23b_get_entry_slider',
	));
}
add_action('init', 'l23b_register_block_entry_slider');