<?php

/**
 * テキスト関連の関数
 */
if (!defined('ABSPATH')) {
	exit;
}

/**
 * 改行を削除
 *
 * @param string $content 改行を削除したい文字列
 * @return string 改行を削除した文字列
 * @version 0.1.0
 */
if (!function_exists('l23b_delete_breaks')) {
	function l23b_delete_breaks($content)
	{

		$content = str_replace(array("\r\n", "\n", "\r"), '', $content);
		$content = str_replace(PHP_EOL, '', $content);
		return $content;
	}
}

/**
 * 複数のスペースを削除
 *
 * @param string $content テキスト
 * @return string 複数のスペースを削除したテキスト
 * @version 0.1.0
 */
if (!function_exists('l23b_trim_same_space')) {
	function l23b_trim_same_space($content)
	{
		// 両サイドのスペースを消す
		$content  = trim($content);
		// タブをスペースへ
		$content  = preg_replace('/[\t]/', '', $content);
		// 複数スペースを一つへ
		$content  = preg_replace('/\s(?=\s)/', '', $content);

		return $content;
	}
}

/**
 * 文字数を丸める
 *
 * @param string $text テキスト
 * @param int $length 最大文字列
 * @return string 丸めた後のテキスト
 * @version 0.1.0
 */
if (!function_exists('l23b_mb_substr_text')) {
	function l23b_mb_substr_text($text, $length = 100)
	{

		/**
		 * 最大文字数よりも長い場合は3点リーダーを付ける
		 */
		$length = $length * 2 + 3; // 3点リーダー分プラス
		
		if (mb_strwidth($text, 'UTF-8') > $length) {
			$text = mb_strimwidth($text, 0, $length, "...", 'UTF-8');
		}
		return $text;
	}
}

/**
 * コンマ区切りの文字列を配列にして返す
 *
 * @param string $str テキスト
 * @return array
 * @version 0.1.0
 */
if (!function_exists('l23b_comma_separated_to_array')) {
	function l23b_comma_separated_to_array($str)
	{

		if ( ! is_string( $str ) ) {
			return false;
		}

		try {
			/**
			 * 全角などにも対応
			 */
			$str_list = str_replace(['，', '、', '､'], ',', $str);
			$str_list = mb_convert_kana($str_list, 'as');
			$str_list = str_replace(array(" ", "　"), "", $str_list);
			$str_list = explode(',', $str_list);

			return $str_list;
		} catch (Exception $e) {
			return false;
		}
	}
}
