<?php

if ( !defined( 'ABSPATH' ) ) {
	exit;
}
function l23b_sanitize_html_available_br( $text ) {

	$allowed_html = array(
	  'br' => array(),
	);
	return wp_kses( $text, $allowed_html );
}

function l23b_sanitize_cropped_image ( $id, $setting ) {
	return ( is_int( $id ) ) ? $id : $setting->default;
}

function l23b_sanitize_checkbox( $checked ) {
	return ( ( isset( $checked ) && $checked ) ? true : '' );
}

function l23b_sanitize_select( $input, $setting ) {
	$input = sanitize_key( $input );
	$choices = $setting->manager->get_control($setting->id)->choices;
	return ( array_key_exists( $input, $choices ) ? $input : $setting->default );
}

function l23b_sanitize_number_range( $number, $setting ) {
	$number = absint( $number );
	$atts = $setting->manager->get_control( $setting->id )->input_attrs;
	$min = ( isset( $atts['min'] ) ? $atts['min'] : $number );
	$max = ( isset( $atts['max'] ) ? $atts['max'] : $number );
	$step = ( isset( $atts['step'] ) ? $atts['step'] : 1 );
	return ( $min <= $number && $number <= $max && is_int( $number / $step ) ? $number : $setting->default );
}

function l23b_sanitize_float_range( $number, $setting ) {

	if( !is_numeric( $number ) ) return $setting->default;

	$number = floatval( $number );
	$atts = $setting->manager->get_control( $setting->id )->input_attrs;

	$min = ( isset( $atts['min'] ) ? floatval( $atts['min'] ) : $number );
	$max = ( isset( $atts['max'] ) ? floatval( $atts['max'] ) : $number );
	$step = ( isset( $atts['step'] ) ? floatval( $atts['step'] ) : 1 );

	return ( $min <= $number && $number <= $max ? strval( $number ) : $setting->default );
}

function l23b_slug_sanitize_image( $image, $setting ) {
	$mimes = array(
		'jpg|jpeg|jpe' => 'image/jpeg',
		'gif'          => 'image/gif',
		'png'          => 'image/png',
		'bmp'          => 'image/bmp',
		'tif|tiff'     => 'image/tiff',
		'ico'          => 'image/x-icon'
	);
	$file = wp_check_filetype( $image, $mimes );
	return ( $file['ext'] ? $image : $setting->default );
}

function l23b_no_sanitize( $input ) {
	return $input;
}