<?php

if (!defined('ABSPATH')) {
	exit;
}

/**
 * カスタマイザーの画像をサイズ指定して取得する
 *
 * @param string $name カスタマイザーのID
 * @param string $size 画像サイズ
 * @return string|false 画像URL
 * @version 0.1.0
 */
if ( ! function_exists( 'l23b_get_the_customizer_image_url' ) ) {
	function l23b_get_the_customizer_image_url( $name, $size = 'full', $type = 'theme_mod' ) {

		$option = '';

		if ( $type === 'theme_mod' ) {
			$option = get_theme_mod( $name, '' );
		} else {
			$option = get_option( $name, '' );
		}

		if ( is_int( $option ) ) {
			$image_data = wp_get_attachment_image_src( $option, '' );
			$image_url = $image_data[0] ?? false;
		} else {
			$image_url = esc_url( $option );
		}

		if ( empty( $image_url ) ) return false;

		$image_id = attachment_url_to_postid( $image_url );

		$image_array = wp_get_attachment_image_src( $image_id, $size );

		$image_url = $image_array[0] ?? false;

		if ( $image_url ) {
			return $image_url;
		} else {
			return false;
		}
	}
}

/**
 * カスタマイザーの画像をサイズ指定して取得する
 *
 * @param string $name カスタマイザーのID
 * @param string $size 画像サイズ
 * @return array|false {
 *     @type string $0 Image source URL.
 *     @type int    $1 Image width in pixels.
 *     @type int    $2 Image height in pixels.
 *     @type bool   $3 Whether the image is a resized image.
 * }
 * @version 0.1.0
 */
if ( ! function_exists( 'l23b_get_the_customizer_image_info' ) ) {
	function l23b_get_the_customizer_image_info( $name, $size = 'full', $type = 'theme_mod' ) {
		$option = '';

		if ( $type === 'theme_mod' ) {
			$option = get_theme_mod( $name, '' );
		} else {
			$option = get_option( $name, '' );
		}

		$image_info_array = null;

		if ( is_int( $option ) ) {
			// IDで取得する場合。

			/**
			 * wp_get_attachment_image_srcの戻り値
			 * [0] => url
			 * [1] => width
			 * [2] => height
			 * [3] => 真偽値: リサイズされいている場合は true、元のサイズの場合は false
			 */
			$image_info_array = wp_get_attachment_image_src( $option, $size );
		} else {
			// URLで取得する場合
			$image_url = esc_url( $option );
			$image_id = attachment_url_to_postid( $image_url );
			$image_info_array = wp_get_attachment_image_src( $image_id, $size );
		}

		if ( ! empty( $image_info_array ) ) {
			return $image_info_array;
		} else {
			return false;
		}
	}
}

// サムネイル画像を取得する関数
if( ! function_exists( 'l23b_get_thumbnail_url' ) ) {
	function l23b_get_thumbnail_url( $id = null, $size = "full" ) {

		if ( ! $id ) $id = get_the_ID();

		$default_thumbnail_url = l23b_get_the_customizer_image_url( 'lab23_default_thumbnail', $size, 'option' );

		if ( has_post_thumbnail( $id ) ) {

			$thumbnail_url = get_the_post_thumbnail_url( $id, $size );

		} elseif ( $default_thumbnail_url ) {

			$thumbnail_url = esc_url( $default_thumbnail_url );

		} else {
			switch ( $size ) {
				case 'full':
					$thumbnail_url = L23B_PLUGIN_DIR_URL . '/images/noimage/noimage.png';
					break;

				case 'large':
					$thumbnail_url = L23B_PLUGIN_DIR_URL . '/images/noimage/noimage-large.png';
					break;

				case 'medium_large':
					$thumbnail_url = L23B_PLUGIN_DIR_URL . '/images/noimage/noimage-medium_large.png';
					break;

				case 'medium':
					$thumbnail_url = L23B_PLUGIN_DIR_URL . '/images/noimage/noimage-medium.png';
					break;

				case 'thumbnail':
					$thumbnail_url = L23B_PLUGIN_DIR_URL . '/images/noimage/noimage-thumbnail.png';
					break;

				default:
					$thumbnail_url = L23B_PLUGIN_DIR_URL . '/images/noimage/noimage.png';
					break;
			}
		}
		return $thumbnail_url;
	}
}

/**
 * サムネイル画像の情報をサイズ指定して取得する
 *
 * @param int $id 投稿ID
 * @param string $size 画像サイズ
 * @return array|false {
 *     @type string $0 Image source URL.
 *     @type int    $1 Image width in pixels.
 *     @type int    $2 Image height in pixels.
 *     @type bool   $3 Whether the image is a resized image.
 * }
 * @version 0.1.0
 */
if( ! function_exists( 'l23b_get_thumbnail_info' ) ) {
	function l23b_get_thumbnail_info( $id = null, $size = "full" ) {

		$url = '';
		$width = null;
		$height = null;
		$is_resized = false;

		if ( ! $id ) $id = get_the_ID();

		$default_thumbnail_info = l23b_get_the_customizer_image_info( 'lab23_default_thumbnail', $size, 'option' );

		if ( has_post_thumbnail( $id ) ) {

			$image_info = wp_get_attachment_image_src( get_post_thumbnail_id( $id ), $size );

			if ( $image_info && isset( $image_info[0] ) ) {
				$url = $image_info[0];
				$width = $image_info[1];
				$height = $image_info[2];
				$is_resized = $image_info[3];
			} else {
				$url = '';
				$width = '';
				$height = '';
			}
			

		} elseif ( $default_thumbnail_info ) {

			$url = $default_thumbnail_info[0];
			$width = $default_thumbnail_info[1];
			$height = $default_thumbnail_info[2];
			$is_resized = $default_thumbnail_info[3];

		} else {
			switch ( $size ) {
				case 'full':
					$url = L23B_PLUGIN_DIR_URL . '/images/noimage/noimage.png';
					$width = 1280;
					$height = 791;
					$is_resized = false;
					break;

				case 'large':
					$url = L23B_PLUGIN_DIR_URL . '/images/noimage/noimage-large.png';
					$width = 1024;
					$height = 633;
					$is_resized = true;
					break;

				case 'medium_large':
					$url = L23B_PLUGIN_DIR_URL . '/images/noimage/noimage-medium_large.png';
					$width = 768;
					$height = 475;
					$is_resized = true;
					break;

				case 'medium':
					$url = L23B_PLUGIN_DIR_URL . '/images/noimage/noimage-medium.png';
					$width = 300;
					$height = 300;
					$is_resized = true;
					break;

				case 'thumbnail':
					$url = L23B_PLUGIN_DIR_URL . '/images/noimage/noimage-thumbnail.png';
					$width = 150;
					$height = 150;
					$is_resized = true;
					break;

				default:
					$url = L23B_PLUGIN_DIR_URL . '/images/noimage/noimage.png';
					$width = 1280;
					$height = 791;
					$is_resized = false;
					break;
			}
		}

		$data = array(
			$url,
			$width,
			$height,
			$is_resized,
		);
		return $data;
	}
}