<?php

if ( ! function_exists( 'l23b_get_post_date_tag') ) {
	function l23b_get_post_date_tag( $post_id = '' , $type = 'post-update' ) {

		if ( $type === 'none' ) return '';
		
		if ( empty( $post_id ) ) {
			$post_id = get_the_ID();
		}

		$datetime = get_the_date( 'Y-m-d', $post_id );
		$update_time = get_the_modified_date( 'Y-m-d', $post_id );

		$update_svg = '<svg xmlns="http://www.w3.org/2000/svg" width="50.918" height="54.02" viewBox="0 0 50.918 54.02"><path d="M524.716,154.038a2.053,2.053,0,0,0-3.44-1.514l-3.883,3.554a27,27,0,1,0,3.5,39.371,5,5,0,0,0-7.433-6.69A17.034,17.034,0,1,1,509.837,163l-3.628,3.322a2.054,2.054,0,0,0,1.2,3.56l15.069,1.363a2.053,2.053,0,0,0,2.238-2.046Z" transform="translate(-473.8 -150.374)"/></svg>';
		$post_svg = '<svg xmlns="http://www.w3.org/2000/svg" width="55.393" height="55.393" viewBox="0 0 55.393 55.393"><g transform="translate(-447.367 -210.991)"><path d="M392.414,186.7a2.492,2.492,0,0,1-1.768-.732l-8.512-8.512a2.5,2.5,0,0,1-.732-1.768V161.28a2.5,2.5,0,1,1,5,0v13.372l7.78,7.779a2.5,2.5,0,0,1-1.768,4.268" transform="translate(91.161 63)"/><path d="M383.9,203.384a27.7,27.7,0,1,1,27.7-27.7,27.727,27.727,0,0,1-27.7,27.7m0-50.393a22.7,22.7,0,1,0,22.7,22.7,22.722,22.722,0,0,0-22.7-22.7" transform="translate(91.161 63)"/></g></svg>';
		?>
<p class="l23b-post-date">
	<?php if( $type === 'post' ) : ?>
		<time datetime="<?php echo $datetime; ?>" class="l23b-post-date__time">
			<?php echo $post_svg; ?>
			<?php echo get_the_date('Y.m.d'); ?>
		</time>
	<?php elseif ( $type === 'update' ) : ?>
		<time datetime="<?php echo $update_time; ?>" class="l23b-post-date__time l23b-post-date__time--update">
			<?php echo $update_svg; ?>
			<?php echo get_the_modified_date('Y.m.d'); ?>
		</time>
	<?php elseif ( $type === 'post-update' ) : ?>
		<?php if( $datetime === $update_time ) : ?>
			<time datetime="<?php echo $datetime; ?>" class="l23b-post-date__time">
				<?php echo $post_svg; ?>
				<?php echo get_the_date('Y.m.d'); ?>
			</time>
		<?php else : ?>
			<time datetime="<?php echo $datetime; ?>" class="l23b-post-date__time">
				<?php echo $post_svg; ?>
				<?php echo get_the_date('Y.m.d'); ?>
			</time>
			<time datetime="<?php echo $update_time; ?>" class="l23b-post-date__time l23b-post-date__time--update">
				<?php echo $update_svg; ?>
				<?php echo get_the_modified_date('Y.m.d'); ?>
			</time>
		<?php endif; ?>
	<?php endif; ?>
</p>
		<?php
	}
}
