<?php

$color_default = [
    [
        'key'       => 'l-23-b-black',
        'name'      => __( '黒', 'lab23-blocks' ),
        'default'   => '#111',
    ],
    [
        'key'       => 'l-23-b-white',
        'name'      => __( '白', 'lab23-blocks' ),
        'default'   => '#fff',
    ],
    [
        'key'       => 'l-23-b-dark-gray',
        'name'      => __( '濃いグレー', 'lab23-blocks' ),
        'default'   => '#6b6b6b'
    ],
    [
        'key'       => 'l-23-b-green',
        'name'      => __( 'グリーン', 'lab23-blocks' ),
        'default'   => '#2aa85e',
    ],
    [
        'key'       => 'l-23-b-turquoise',
        'name'      => __( 'ターコイズ', 'lab23-blocks' ),
        'default'   => '#36b8bc',
    ],
    [
        'key'       => 'l-23-b-blue',
        'name'      => __( 'ブルー', 'lab23-blocks' ),
        'default'   => '#1f62c1',
    ],
    [
        'key'       => 'l-23-b-purple',
        'name'      => __( 'パープル', 'lab23-blocks' ),
        'default'   => '#b438c1',
    ],
    [
        'key'       => 'l-23-b-red',
        'name'      => __( 'レッド', 'lab23-blocks' ),
        'default'   => '#b71414',
    ],
    [
        'key'       => 'l-23-b-pink',
        'name'      => __( 'ピンク', 'lab23-blocks' ),
        'default'   => '#d15353',
    ],
    [
        'key'       => 'l-23-b-orange',
        'name'      => __( 'オレンジ', 'lab23-blocks' ),
        'default'   => '#e87e0d',
    ],
    [
        'key'       => 'l-23-b-yellow',
        'name'      => __( 'イエロー', 'lab23-blocks' ),
        'default'   => '#f0f00e',
    ],
    [
        'key'       => 'l-23-b-light-gray',
        'name'      => __( 'ライトグレー', 'lab23-blocks' ),
        'default'   => '#999999',
    ],
    [
        'key'       => 'l-23-b-light-green',
        'name'      => __( 'ライトグリーン', 'lab23-blocks' ),
        'default'   => '#86e5ad',
    ],
    [
        'key'       => 'l-23-b-light-turquoise',
        'name'      => __( 'ライトターコイズ', 'lab23-blocks' ),
        'default'   => '#82d4d7',
    ],
    [
        'key'       => 'l-23-b-light-blue',
        'name'      => __( 'ライトブルー', 'lab23-blocks' ),
        'default'   => '#90c4ed',
    ],
    [
        'key'       => 'l-23-b-light-purple',
        'name'      => __( 'ライトパープル', 'lab23-blocks' ),
        'default'   => '#e188eb',
    ],
    [
        'key'       => 'l-23-b-light-pink',
        'name'      => __( 'ライトピンク', 'lab23-blocks' ),
        'default'   => '#e79090',
    ],
    [
        'key'       => 'l-23-b-light-orange',
        'name'      => __( 'ライトオレンジ', 'lab23-blocks' ),
        'default'   => '#eeaf6c',
    ],
    [
        'key'       => 'l-23-b-light-yellow',
        'name'      => __( 'ライトイエロー', 'lab23-blocks' ),
        'default'   => '#f2f274',
    ],
    [
        'key'       => 'l-23-b-pale-gray',
        'name'      => __( '淡いグレー', 'lab23-blocks' ),
        'default'   => '#f5f5f5',
    ],
    [
        'key'       => 'l-23-b-pale-turquoise',
        'name'      => __( '淡いターコイズ', 'lab23-blocks' ),
        'default'   => '#cbeff0',
    ],
    [
        'key'       => 'l-23-b-pale-blue',
        'name'      => __( '淡いブルー', 'lab23-blocks' ),
        'default'   => '#d4e9f9',
    ],
    [
        'key'       => 'l-23-b-pale-purple',
        'name'      => __( '淡いパープル', 'lab23-blocks' ),
        'default'   => '#f1d6f4',
    ],
    [
        'key'       => 'l-23-b-pale-pink',
        'name'      => __( '淡いピンク', 'lab23-blocks' ),
        'default'   => '#fcd4d4',
    ],
    [
        'key'       => 'l-23-b-pale-orange',
        'name'      => __( '淡いオレンジ', 'lab23-blocks' ),
        'default'   => '#f9ebd9',
    ],
    [
        'key'       => 'l-23-b-pale-yellow',
        'name'      => __( '淡いイエロー', 'lab23-blocks' ),
        'default'   => '#fafad5',
    ],
    [
        'key'       => 'l-23-b-custom-1',
        'name'      => __( 'カスタム 1', 'lab23-blocks' ),
        'default'   => '#eee',
    ],
    [
        'key'       => 'l-23-b-custom-2',
        'name'      => __( 'カスタム 2', 'lab23-blocks' ),
        'default'   => '#ddd',
    ],
    [
        'key'       => 'l-23-b-custom-3',
        'name'      => __( 'カスタム 3', 'lab23-blocks' ),
        'default'   => '#ccc',
    ],
];
define('L23B_DEFAULT_COLORS', $color_default);

function l23b_color_palette() {
    $palette = array();

    $color_settings = L23B_DEFAULT_COLORS;

    foreach ($color_settings as $color) {
        array_push($palette, [
            'name'  => $color['name'],
            'slug'  => $color['key'],
            'color' => get_option('l23b_block_color_' . $color['key'], $color['default']),
        ]);
    }

    add_theme_support('editor-color-palette', $palette);
}

add_action('init', 'l23b_color_palette', 11);

if (!function_exists('l23b_get_inline_style')) {
    function l23b_get_inline_style() {

        $color_settings = L23B_DEFAULT_COLORS;
        
        ob_start();
foreach ($color_settings as $color) {
    $value = get_option('l23b_block_color_' . $color["key"], $color["default"]);
    echo '.has-' . $color['key'] . '-color {color: ' . $value . ';}';
    echo '.has-' . $color['key'] . '-background-color{background-color: ' . $value . ';}';
}
        $style = ob_get_contents();
        ob_end_clean();
        
        return $style;
    }
}


if (!function_exists('l23b_output_inline_style')) {
    function l23b_output_inline_style() {
        $style = l23b_get_inline_style();
        wp_add_inline_style('lab23-blocks-style', $style);
    }
    add_action('wp_enqueue_scripts', 'l23b_output_inline_style');
}

if (!function_exists('l23b_output_inline_editor_style')) {
    function l23b_output_inline_editor_style()
    {
        $style = l23b_get_inline_style();
        wp_add_inline_style('lab23-blocks-editor-style', $style);
    }
    add_action('enqueue_block_editor_assets', 'l23b_output_inline_editor_style');
}

