<?php

/**
 * @link https://jajaaan.co.jp/wordpress/wordpress-admin-page/
 */

function l23b_general_settings_menu_page() {
    add_menu_page( 'ブロック設定', 'ブロック設定', 'manage_options', 'block_settings_page', 'l23b_add_general_settings_menu_page', 'dashicons-admin-generic', 20 );
    add_action( 'admin_init', 'l23b_register_custom_setting' );
}
add_action( 'admin_menu', 'l23b_general_settings_menu_page' );

function l23b_add_general_settings_menu_page() {
    $color_settings = L23B_DEFAULT_COLORS;
    $color_num = 1;
?>
    <div class="l23b-settings-page">
        <h2 class="l23b-settings-page__ttl">ブロック設定画面</h2>
        <div class="l23b-settings-form-wrap">
            <div class="l23b-settings-group">
                <form method="post" action="options.php" enctype="multipart/form-data" encoding="multipart/form-data">
                    <?php
                    settings_fields('block-settings-group');
                    do_settings_sections('block-settings-group');
                    ?>
                    <div class="l23b-settings-group-item">
                        <h3>カラーパレット設定</h3>
                        <div class="l23b-settings-color-list">
                            <?php foreach ($color_settings as $color) : ?>
                                <div class="l23b-settings-color">
                                    <label for=""><?php echo $color['name']; ?></label><br />
                                    <input type="text" name="l23b_block_color_<?php echo $color['key']; ?>" class="add-color-picker-number-field color-palette-item" value="<?php echo get_option('l23b_block_color_' . $color["key"], $color["default"]); ?>" data-default="<?php echo $color["default"]; ?>">
                                </div>
                                <?php $color_num++; ?>
                            <?php endforeach; ?>
                        </div>

                    </div>
                    <?php submit_button(); ?>
                </form>
            </div>

        </div>
    </div>
<?php
}

function l23b_register_custom_setting()
{
    $color_length = 15;

    $color_settings = L23B_DEFAULT_COLORS;

    foreach($color_settings as $color) {
        register_setting( 'block-settings-group', 'l23b_block_color_' . $color['key'] );
    }
}
